//=============================================================================
// Button1.
//=============================================================================
class PreviewSoundButton extends MSCCraftingDeco;

#exec TEXTURE IMPORT NAME="PreviewSoundButton" FILE="Textures\SoundPreviewButton.pcx" GROUP=Skins

var() sound PreviewSound;

var Vector	lastLoc, rpcLocation;
var bool		bIsMoving;
var rotator rpcRotation;

replication 
{
	reliable if ( Role == ROLE_Authority )
		rpcLocation, rpcRotation;
}

function Frob(Actor Frobber, Inventory frobWith)
{
		PlaySound(PreviewSound, SLOT_None);

		Super.Frob(Frobber, frobWith);
}

singular function SupportActor(Actor standingActor)
{
	// do nothing
}

function Bump(actor Other)
{
	// do nothing
}

simulated function Tick( float deltaTime )
{						  	
	if ( Level.NetMode != NM_Standalone )
	{
		if ( Role == ROLE_Authority )
		{
			// Was moving, now at rest
			if ( bIsMoving && ( Location == lastLoc ))
			{
				rpcLocation = Location;
                                rpcRotation = Rotation;
			}
			bIsMoving = ( Location != lastLoc );
			lastLoc = Location;
		}
		else
		{
			// Our replicated location changed which means the button has come to rest
			if ( lastLoc != rpcLocation )
			{
				SetLocation( rpcLocation );
				SetRotation( rpcRotation );
				lastLoc = rpcLocation;
			}
		}
	}
	Super.Tick( deltaTime );
}
defaultproperties
{
     bBlockActors=True
     bBlockPlayers=True
     bInvincible=True
     ItemName="Sound Preview Button"
     bPushable=False
     Physics=PHYS_None
     Skin=Texture'PreviewSoundButton'
     RemoteRole=ROLE_SimulatedProxy
     Mesh=LodMesh'DeusExDeco.Button1'
     CollisionRadius=2.000000
     CollisionHeight=2.000000
     bCollideWorld=False
     Mass=5.000000
     Buoyancy=2.000000
}

